/*
 * UART.cpp
 *
 *  Created on: Mar 23, 2015
 *      Author: Austin Riffle
 */

#include "UartInterface.h"

namespace uart
{
/***************************************************************************************/

// function to initialize UART at for 8-N-1 configuration at a given baud rate
void UartInterface::begin(uint32_t baudRate)
{
	//Enbale UART1 for MIDI communication
	SysCtlPeripheralEnable(uartPeripheral);

	//Configure PB0 to receive data from MIDI instrument/interrupter
	GPIOPinConfigure(uartRxGpioPin);
	//Configure PB1 to transmit data to the interrupter
	GPIOPinConfigure(uartTxGpioPin);
	GPIOPinTypeUART(uartPortBase, uartRxPinNumber | uartTxPinNumber);

	//Configure the UART to run at the MIDI baud rate with a word length of 8 bits
	UARTConfigSetExpClk(uartBase, SysCtlClockGet(), baudRate,
					   (UART_CONFIG_WLEN_8 | UART_CONFIG_STOP_ONE | UART_CONFIG_PAR_NONE));
}

/***************************************************************************************/

// function to send one byte of data over UART
void UartInterface::write(uint8_t byte)
{
	UARTCharPut(uartBase, (unsigned char)byte);
}

/***************************************************************************************/

bool UartInterface::available(void)
{
	return UARTCharsAvail(uartBase);
}

/***************************************************************************************/

uint8_t UartInterface::read()
{
	return (uint8_t)(UARTCharGet(uartBase));
}

/***************************************************************************************/

}
